<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="images/favicon.png" rel="icon"/>
    <title>Payments Report</title>


    <!-- Web Fonts
    ======================= -->
    <link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900'
          type='text/css'>
    <!-- Stylesheet
    ======================= -->
    <link rel="stylesheet" type="text/css"
          href="https://harnishdesign.net/demo/html/koice/vendor/bootstrap/css/bootstrap.min.css"/>
    <link rel="stylesheet" type="text/css"
          href="https://harnishdesign.net/demo/html/koice/vendor/font-awesome/css/all.min.css"/>
    <link rel="stylesheet" type="text/css" href="https://harnishdesign.net/demo/html/koice/css/stylesheet.css"/>
    <style>
        .hide {
            display: none;
        }
        .txt-sm{
            font-size: small;
        }


        body {
            font-family: "Source Sans Pro", sans-serif;
            margin: 0;
            background-color: white !important;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            margin: 0;
        }

        .container {
            max-width: 1000px;
            margin-right: auto;
            margin-left: auto;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .table {
            width: 100%;
            border: 1px solid #eeeeee;
        }
        table, th, td {
            width: 100%;
            border-top: 1px solid black;
            border-bottom: 1px solid black;
            border-collapse: collapse;
        }
    </style>
</head>
<body>
<!-- Container -->
<div class="container-fluid invoice-container">
    <!-- Header -->
    <header>
        <div class="row align-items-center">
            <div class="col-sm-7 text-center text-sm-start mb-3 mb-sm-0">
                <img id="logo" src="https://geoplankenya.com/stockmanager/assets/uploads/logos/Tech-Firm_Logo.png"
                     title="Logo" alt="Logo"/>
            </div>
            <div class="col-sm-5 text-center text-sm-end">
                <h4 class="text-7 mb-0">Payments Report</h4>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main>
        <div class="row hide">
            <div class="col-sm-6 text-sm-end order-sm-1 hide"><strong>Company:</strong>
                <address>
                    Sagana Plantraisers<br/>
                    Karatina, Nairobi<br/>
                    Tel: 0721536097<br/>
                    Email: artpac.tech@gmail.com<br/>
                </address>
            </div>
        </div>

        <div class="card">
            <div class="card-body p-0">

                <div class="table-responsive">
                    <table class="table mb-0 table-striped">
                        <thead class="card-header">
                        <tr>
                            <td class="col-2"><strong>Date</strong></td>
                            <td class="col-2"><strong>Reference</strong></td>
                            <td class="col-2"><strong>Customer</strong></td>
                            <td class="col-2"><strong>Phone</strong></td>
                            <td class="col-1 text-end"><strong>Amount</strong></td>
                            <td class="col-2 text-end"><strong>Method</strong></td>
                        </tr>
                        </thead>
                        <tbody>
                        <?php

                        foreach ($payments as $row) {
                            ?>
                            <tr>
                                <td class="col-2 txt-sm"><?=date('d/m/y',strtotime($row->date)); ?></td>
                                <td class="col-2 txt-sm"><?=$row->payment_ref; ?></td>
                                <td class="col-2 txt-sm"><?=$row->name; ?></td>
                                <td class="col-2 txt-sm"><?=$row->phone; ?></td>
                                <td class="col-1 text-end txt-sm"><?= isset($row->amount) ? $this->sma->formatMoney($row->amount) : '0.00' ?></td>
                                <td class="col-2 text-end"><?= $row->paid_by ?? '' ?></td>
                            </tr>
                            <?php
                        }
                        ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>
</div>
</body>
</html>