<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<!-- Script updated for new amount columns, totals, and running balance -->
<script>
    $(document).ready(function () {
        // Initialize select2 for product suggestion
        $('#suggest_product').select2({
            minimumInputLength: 1,
            ajax: {
                url: site.base_url + "reports/suggestions",
                dataType: 'json',
                quietMillis: 15,
                data: function (term, page) {
                    return { term: term, limit: 10 };
                },
                results: function (data, page) {
                    if (data.results != null) {
                        return {results: data.results};
                    } else {
                        return {results: [{id: '', text: 'No Match Found'}]};
                    }
                }
            }
        }).on('change', function(e) {
            // Set the hidden product ID input when a product is selected
            $('#report_product_id').val(e.val);
        });

        var oTable;

        // Function to load/reload the datatable
        function load_report() {
            if (oTable) {
                oTable.fnDestroy(); // Destroy existing table before reloading
            }
            
            oTable = $('#BatchTrackingTable').dataTable({
                "aaSorting": [], // Sorting is now handled server-side
                "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "<?= lang('all') ?>"]],
                "iDisplayLength": <?= $Settings->rows_per_page ?>,
                'bProcessing': true,
                'bServerSide': true,
                'bFilter': false, 
                'sAjaxSource': '<?= admin_url('reports/get_batch_tracking_report_serverside') ?>',
                'fnServerData': function (sSource, aoData, fnCallback, oSettings) {
                    aoData.push({ "name": "<?= $this->security->get_csrf_token_name() ?>", "value": "<?= $this->security->get_csrf_hash() ?>" });
                    aoData.push({ "name": "product", "value": $('#report_product_id').val() });
                    aoData.push({ "name": "batch_no", "value": $('#batch_no').val() });
                    aoData.push({ "name": "start_date", "value": $('#start_date').val() });
                    aoData.push({ "name": "end_date", "value": $('#end_date').val() });
                    aoData.push({ "name": "type", "value": $('#type').val() });
                    
                    $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 
                        'success': function(json) {
                            fnCallback(json);
                            if(json.totals) {
                                $('#total_debit_qty').text(formatQuantity(json.totals.total_debit_qty));
                                $('#total_credit_qty').text(formatQuantity(json.totals.total_credit_qty));
                                $('#total_debit_amount').text(currencyFormat(json.totals.total_debit_amount));
                                $('#total_credit_amount').text(currencyFormat(json.totals.total_credit_amount));
                            }
                        }
                    });
                },
                "aoColumns": [
                    {"mRender": fld}, // 0: Date
                    {"bSortable": false}, // 1: Product Name
                    {"bSortable": false}, // 2: Batch No
                    {"bSortable": false}, // 3: Type
                    {"bSortable": false}, // 4: Ref
                    {"bSortable": false}, // 5: Party
                    {"mRender": decimalFormat, "bSortable": false, "sClass": "text-right"}, // 6: Debit Qty
                    {"mRender": decimalFormat, "bSortable": false, "sClass": "text-right"}, // 7: Credit Qty
                    {"mRender": currencyFormat, "bSortable": false, "sClass": "text-right"}, // 8: Debit Amount
                    {"mRender": currencyFormat, "bSortable": false, "sClass": "text-right"}, // 9: Credit Amount
                    {"mRender": decimalFormat, "bSortable": false, "sClass": "text-right"}, // 10: Running Balance
                    {"bSortable": false, "bSearchable": false, "sClass": "text-center"}        // 11: Actions
                ]
            });
        }

        $('#filter-form').on('submit', function(e) {
            e.preventDefault();
            oTable.fnDraw();
        });

        $(document).on('click', '.view-transaction', function(e) {
            e.preventDefault();
            var href = $(this).attr('href');
            if (href) {
                $('#myModalLabel').text($(this).attr('title'));
                $('#myModal .modal-body').load(href, function(response, status, xhr) {
                    if (status == "error") {
                        $(this).html("<div class='alert alert-danger'>Sorry, but there was an error loading the details.</div>");
                    }
                    $('#myModal').modal('show');
                });
            }
        });

        function get_export_query_string() {
            var product_id = $('#report_product_id').val();
            var batch_no = $('#batch_no').val();
            var start_date = $('#start_date').val();
            var end_date = $('#end_date').val();
            var type = $('#type').val();
            var qs = '?v=1';
            if (product_id) { qs += '&product=' + encodeURIComponent(product_id); }
            if (batch_no) { qs += '&batch_no=' + encodeURIComponent(batch_no); }
            if (start_date) { qs += '&start_date=' + encodeURIComponent(start_date); }
            if (end_date) { qs += '&end_date=' + encodeURIComponent(end_date); }
            if (type) { qs += '&type=' + encodeURIComponent(type); }
            return qs;
        }

        $('#pdf').click(function(e) {
            e.preventDefault();
            window.location.href = '<?= admin_url('reports/get_batch_tracking_report/pdf') ?>' + get_export_query_string();
            return false;
        });

        $('#xls').click(function(e) {
            e.preventDefault();
            window.location.href = '<?= admin_url('reports/get_batch_tracking_report/0/xls') ?>' + get_export_query_string();
            return false;
        });

        load_report();
    });
</script>

<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-history"></i><?= lang('batch_tracking_report'); ?></h2>
        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown"><a href="#" id="pdf" class="tip" title="<?= lang('download_pdf') ?>"><i class="icon fa fa-file-pdf-o"></i></a></li>
                <li class="dropdown"><a href="#" id="xls" class="tip" title="<?= lang('download_xls') ?>"><i class="icon fa fa-file-excel-o"></i></a></li>
            </ul>
        </div>
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><?= lang('customize_report'); ?></p>
                
                <div id="form">
                    <?php echo admin_form_open('reports/batch_tracking', 'id="filter-form"'); ?>
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang('product', 'suggest_product'); ?>
                                <?php echo form_input('sproduct', '', 'class="form-control" id="suggest_product" style="width:100%;"'); ?>
                                <input type="hidden" name="product" value="" id="report_product_id"/>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang('batch_no', 'batch_no'); ?>
                                <?php echo form_input('batch_no', '', 'class="form-control" id="batch_no"'); ?>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang('type', 'type'); ?>
                                <?php
                                $types = ['' => lang('all'), 'Purchase' => lang('purchase'), 'Sale' => lang('sale')];
                                echo form_dropdown('type', $types, '', 'class="form-control" id="type" data-placeholder="' . lang("select") . ' ' . lang("type") . '" style="width:100%;"');
                                ?>
                            </div>
                        </div>
                         <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang('start_date', 'start_date'); ?>
                                <?php echo form_input('start_date', '', 'class="form-control datetime" id="start_date"'); ?>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <?= lang('end_date', 'end_date'); ?>
                                <?php echo form_input('end_date', '', 'class="form-control datetime" id="end_date"'); ?>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="controls">
                            <?php echo form_submit('submit_report', $this->lang->line('submit'), 'class="btn btn-primary"'); ?>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
                <div class="clearfix"></div>

                <div class="table-responsive">
                    <table id="BatchTrackingTable" class="table table-bordered table-hover table-striped table-condensed">
                        <thead>
                        <tr>
                            <th><?= lang('date'); ?></th>
                            <th><?= lang('product_name'); ?></th>
                            <th><?= lang('batch_no'); ?></th>
                            <th><?= lang('type'); ?></th>
                            <th><?= lang('transaction_ref'); ?></th>
                            <th><?= lang('party'); ?></th>
                            <th><?= lang('debit').' (Qty)'; ?></th>
                            <th><?= lang('credit').' (Qty)'; ?></th>
                            <th><?= lang('debit_amount'); ?></th>
                            <th><?= lang('credit_amount'); ?></th>
                            <th><?= lang('balance').' (Qty)'; ?></th>
                            <th style="width:80px; text-align:center;"><?= lang('actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td colspan="12" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td>
                        </tr>
                        </tbody>
                        <tfoot class="dtFilter">
                            <tr>
                                <th colspan="6" style="text-align:right;"><?= lang('total'); ?>:</th>
                                <th id="total_debit_qty" class="text-right"></th>
                                <th id="total_credit_qty" class="text-right"></th>
                                <th id="total_debit_amount" class="text-right"></th>
                                <th id="total_credit_amount" class="text-right"></th>
                                <th colspan="2"></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal container for viewing transaction details -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel"></h4>
            </div>
            <div class="modal-body">
                <!-- Content is loaded here dynamically by the JavaScript handler -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('close') ?></button>
            </div>
        </div>
    </div>
</div>
<!-- End of modal for viewing transaction details -->