<?php

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Pdf\Mpdf;

defined('BASEPATH') or exit('No direct script access allowed');

if (!function_exists('create_excel')) {
    function create_excel($excel, $filename)
    {
        header('Content-Type: ' . get_mime_by_extension('xlsx') . ' charset=utf-8');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');

        $objWriter = IOFactory::createWriter($excel, 'Xlsx');
        $objWriter->save('php://output');
        exit;
    }
}
if (!function_exists('create_pdf')) {
    function create_pdf($excel, $filename)
    {
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment;filename="' . $filename . '.pdf"');
        header('Cache-Control: max-age=0');
        IOFactory::registerWriter('Pdf', Mpdf::class);
        $objWriter = IOFactory::createWriter($excel, 'Pdf');
        $objWriter->save('php://output');
        exit;
    }
}
